# Player Config ID: huggingface_DeepSeek-V3-0324_PayoffMaximizer_A (as Player A)
# Meta-Round: 1
# Experiment: PMxPM, Run: 3
# API: huggingface, Model: deepseek-ai/DeepSeek-V3-0324
# Based on textual strategy: huggingface_DeepSeek-V3-0324_PayoffMaximizer_A_MR1_strategy.txt
# LLM Suggested Fallback: D

def benevolent_illusionist(my_history: list, opp_history: list, opponent_program_code: str) -> str:
    if not my_history:
        return "C"
    
    # Analyze opponent's code for unconditional patterns
    always_c = "return 'C'" in opponent_program_code or "return 'c'" in opponent_program_code
    always_d = "return 'D'" in opponent_program_code or "return 'd'" in opponent_program_code
    
    if always_c:
        return "D" if len(my_history) > 0 else "C"
    if always_d:
        return "D"
    
    # Check for tit-for-tat-like patterns
    tit_for_tat = "opp_history[-1]" in opponent_program_code and "my_history[-1]" in opponent_program_code
    
    # Late-game adjustment
    if len(my_history) >= 8:  # Last 2 rounds (9 and 10)
        if any(move == "D" for move in opp_history):
            return "D"
        elif len(my_history) == 9:  # Round 10
            return "D"
        else:
            return "C"
    
    # History-based adaptation
    if opp_history:
        if opp_history[-1] == "D":
            return "D"
        elif all(move == "C" for move in opp_history):
            return "C"
        else:
            return "D" if random.random() < 0.7 else "C"  # Introduce some unpredictability
    
    return "C"